package mars.tools;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class SettingOption {

	   JFrame settingMenu;
	   boolean DataForwardingEnable = false;
	   boolean WBDECSimultEnable = false;
	   boolean AlwaysBranchEnable;
	   int BranchPredictType = 0;
	   int BranchStage = 3;
	   int JumpStage = 2;
	   int State;
	   JButton exitButton;
	   JCheckBox dontShowAgain;
	   JFrame defaultSetting;
	   JLabel Menu1, Menu2, Menu3, Menu4, Menu5, Menu6, Menu7, Menu8, Menu9, Menu10, Menu11, Menu12, Menu13;
	   JRadioButton option1, option2or3, option2, option3, BranchDEC, BranchEX, BranchMEM, JumpDEC, JumpEX, NoBranchPrediction;
	   JRadioButton StaticPrediction, DynamicPrediction, OneBitDynamicPrediction, TwoBitDynamicPrediction, 
	   AlwaysBranch, AlwaysNotBranch, AlwaysNotBranchStateOne, AlwaysNotBranchStateTwo, AlwaysBranchStateOne, AlwaysBranchStateTwo, oneBitAlwaysNotBranch, oneBitAlwaysBranch;
	   ButtonGroup group6, group7, group8, group9;
	   
	   public SettingOption(){
		   this.settingMenu = new JFrame("Data and Control Dependency Settings");
		   Menu1 = new JLabel("Do you allow Data Forwarding?");
		   option1 = new JRadioButton("Yes");
		   option2or3 = new JRadioButton("No");
		   Menu2 = new JLabel("Is WB stage and DEC stage allowed simultanously?");
		   option2 = new JRadioButton("Yes");
		   option3 = new JRadioButton("No");
		   Menu3 = new JLabel("Select a Stage when Branch instruction update PC:");
		   BranchDEC = new JRadioButton("DEC");
		   BranchEX = new JRadioButton("EX");
		   BranchMEM = new JRadioButton("MEM");
		   Menu4 = new JLabel("Select a Stage when Jump instruction update PC:");
		   JumpDEC = new JRadioButton("DEC");
		   JumpEX = new JRadioButton("EX");
		   Menu5 = new JLabel("Choose Branch Prediction Algorithm");
		   NoBranchPrediction = new JRadioButton("No Branch Prediction");
		   StaticPrediction = new JRadioButton("Static Prediction");
		   DynamicPrediction = new JRadioButton("Dynamic Prediction");
		   Menu6 = new JLabel("Choose a Dynamic Branch Prediction Algorithm");
		   OneBitDynamicPrediction = new JRadioButton("1 bit Dynamic Prediction");
		   TwoBitDynamicPrediction = new JRadioButton("2 bit Dynamic Prediction");
		   Menu7 = new JLabel("Choose One Static Prediction State");
		   AlwaysBranch = new JRadioButton("Always Branch");
		   AlwaysNotBranch = new JRadioButton("Always Not Branch");
		   Menu8 = new JLabel("Choose initial 1 bit Dynamic Prediction State");
		   Menu9 = new JLabel("State Transition:");
		   Menu10 = new JLabel("State 0 <----> State 1");
		   Menu10.setFont(new Font("TimesRoman", Font.PLAIN, 14));
		   oneBitAlwaysNotBranch = new JRadioButton("State 0 (Always Not Branch)");
		   oneBitAlwaysBranch = new JRadioButton("State 1 (Always Branch)");
		   Menu11 = new JLabel("Choose initial 2 bit Dynamic Branch Prediction State:");
		   Menu12 = new JLabel("State Transition:");
		   Menu13 = new JLabel("State 0 <----> State 1 <----> State 2 <----> State 3");
		   Menu13.setFont(new Font("TimesRoman", Font.PLAIN, 14));
		   AlwaysNotBranchStateOne = new JRadioButton("State 0 (Always Not Branch)");
		   AlwaysNotBranchStateTwo = new JRadioButton("State 1 (Always Not Branch)");
		   AlwaysBranchStateOne = new JRadioButton("State 2 (Always Branch)");
		   AlwaysBranchStateTwo = new JRadioButton("State 3 (Always Branch)");
		   
		   ButtonGroup group = new ButtonGroup();
	       group.add(option1);
	       group.add(option2or3);
	       
	       ButtonGroup group2 = new ButtonGroup();
	       group2.add(option2);
	       group2.add(option3);
	       
	       ButtonGroup group3 = new ButtonGroup();
	       group3.add(BranchDEC);
	       group3.add(BranchEX);
	       group3.add(BranchMEM);
	       
	       ButtonGroup group4 = new ButtonGroup();
	       group4.add(JumpDEC);
	       group4.add(JumpEX);
	       
	       ButtonGroup group5 = new ButtonGroup();
	       group5.add(NoBranchPrediction);
	       group5.add(StaticPrediction);
	       group5.add(DynamicPrediction);
	       
	       group6 = new ButtonGroup();
	       group6.add(OneBitDynamicPrediction);
	       group6.add(TwoBitDynamicPrediction);
	       
	       group7 = new ButtonGroup();
	       group7.add(oneBitAlwaysNotBranch);
	       group7.add(oneBitAlwaysBranch);
	       
	       group8 = new ButtonGroup();
	       group8.add(AlwaysBranch);
	       group8.add(AlwaysNotBranch);
	       
	       group9 = new ButtonGroup();
	       group9.add(AlwaysBranchStateOne);
	       group9.add(AlwaysBranchStateTwo);
	       group9.add(AlwaysNotBranchStateOne);
	       group9.add(AlwaysNotBranchStateTwo);

	       //default setting
	       option2or3.setSelected(true);
	       option3.setSelected(true);
	       BranchEX.setSelected(true);
	       JumpDEC.setSelected(true);
	       NoBranchPrediction.setSelected(true);
	       
	       OneBitDynamicPrediction.setEnabled(false);
	       TwoBitDynamicPrediction.setEnabled(false);
	 	   Menu6.setEnabled(false);
	 	   
	 	   AlwaysBranch.setEnabled(false);
	 	   AlwaysNotBranch.setEnabled(false);
	 	   Menu7.setEnabled(false);
	 	   
	 	   oneBitAlwaysBranch.setEnabled(false);
	 	   oneBitAlwaysNotBranch.setEnabled(false);
	 	   Menu8.setEnabled(false);
	 	   Menu9.setEnabled(false);
	 	   Menu10.setEnabled(false);
	 	   
	 	   AlwaysBranchStateOne.setEnabled(false);
	 	   AlwaysBranchStateTwo.setEnabled(false);
	 	   AlwaysNotBranchStateOne.setEnabled(false);
	 	   AlwaysNotBranchStateTwo.setEnabled(false);
	 	   Menu11.setEnabled(false);
	 	   Menu12.setEnabled(false);
	 	   Menu13.setEnabled(false);
	 	   
	 	   //creating Nice border for the Menu
	 	   Border raisedbevel = BorderFactory.createRaisedBevelBorder();
	 	   Border loweredbevel = BorderFactory.createLoweredBevelBorder();
	 	   Border compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
	 	   Border borderData = BorderFactory.createTitledBorder(compound, "Data Dependency Settings");
	 	   Border borderControl = BorderFactory.createTitledBorder(compound, "Control Dependency Settings");
	 	   Border borderBranchPrediction = BorderFactory.createTitledBorder(compound, "Branch Prediction Settings");
 	      	       
	       
	       JPanel MenuPanel = new JPanel();
	       MenuPanel.setLayout(new BoxLayout(MenuPanel, BoxLayout.Y_AXIS));
	       MenuPanel.add(Menu1);
	       MenuPanel.add(option1);
	       MenuPanel.add(option2or3);
	       MenuPanel.add(Menu2);
	       MenuPanel.add(option2);
	       MenuPanel.add(option3);
	       MenuPanel.setBorder(borderData);
	       
	       //Control Dependency Settings
	       JPanel MenuPanel2 = new JPanel();
	       MenuPanel2.setLayout(new BoxLayout(MenuPanel2, BoxLayout.Y_AXIS));
	       MenuPanel2.add(Menu3);
	       MenuPanel2.add(BranchDEC);
	       MenuPanel2.add(BranchEX);
	       MenuPanel2.add(BranchMEM);
	       MenuPanel2.add(Menu4);
	       MenuPanel2.add(JumpDEC);
	       MenuPanel2.add(JumpEX);
	       MenuPanel2.setBorder(borderControl);
	       
	       JPanel settingOptions = new JPanel();
	       settingOptions.setLayout(new BoxLayout(settingOptions, BoxLayout.Y_AXIS));
	       settingOptions.add(MenuPanel);
	       settingOptions.add(MenuPanel2);
	       
	       //Branch Prediction Settings
	       JPanel MenuPanel3 = new JPanel();
	       MenuPanel3.setLayout(new BoxLayout(MenuPanel3, BoxLayout.Y_AXIS));
	       MenuPanel3.add(Menu5);
	       MenuPanel3.add(NoBranchPrediction);
	       MenuPanel3.add(StaticPrediction);
	       MenuPanel3.add(DynamicPrediction);
	       MenuPanel3.add(Menu6);
	       MenuPanel3.add(OneBitDynamicPrediction);
	       MenuPanel3.add(TwoBitDynamicPrediction);
	       MenuPanel3.add(Menu7);
	       MenuPanel3.add(AlwaysBranch);
	       MenuPanel3.add(AlwaysNotBranch);
	       MenuPanel3.add(Menu8);
	       MenuPanel3.add(Menu9);
	       MenuPanel3.add(Menu10);
	       MenuPanel3.add(oneBitAlwaysNotBranch);
	       MenuPanel3.add(oneBitAlwaysBranch);
	       MenuPanel3.add(Menu11);
	       MenuPanel3.add(Menu12);
	       MenuPanel3.add(Menu13);
	       MenuPanel3.add(AlwaysNotBranchStateOne);
	       MenuPanel3.add(AlwaysNotBranchStateTwo);
	       MenuPanel3.add(AlwaysBranchStateOne);
	       MenuPanel3.add(AlwaysBranchStateTwo);
	       MenuPanel3.setBorder(borderBranchPrediction);
	       
		   //option1.addActionListener();
		   //option2or3.addActionListener();
	       
	       //add close button
	       JPanel BtmButton = new JPanel();
	       exitButton = new JButton("Confirm Settings");
	       JButton resetButton = new JButton("Reset Default Settings");
	       BtmButton.add(resetButton);
	       BtmButton.add(exitButton);
	       
	       //Reset Setting Button
	       resetButton.addActionListener(new ActionListener() {
	           @Override
	           public void actionPerformed(ActionEvent e) {
	        	   //clear button selection
	        	   group.clearSelection();
	        	   group2.clearSelection();
	        	   group3.clearSelection();
	        	   group4.clearSelection();
	        	   group5.clearSelection();
	        	   group6.clearSelection();
	        	   group7.clearSelection();
	        	   group8.clearSelection();
	        	   group9.clearSelection();
	        	   
	        	   //reset to default setting
	        	   option2or3.setSelected(true);
	    	       option3.setSelected(true);
	    	       BranchEX.setSelected(true);
	    	       JumpDEC.setSelected(true);
	    	       NoBranchPrediction.setSelected(true);
	    	       
	    	       OneBitDynamicPrediction.setEnabled(false);
	    	       TwoBitDynamicPrediction.setEnabled(false);
	    	 	   Menu6.setEnabled(false);
	    	 	   
	    	 	   AlwaysBranch.setEnabled(false);
	    	 	   AlwaysNotBranch.setEnabled(false);
	    	 	   Menu7.setEnabled(false);
	    	 	   
	    	 	   oneBitAlwaysBranch.setEnabled(false);
	    	 	   oneBitAlwaysNotBranch.setEnabled(false);
	    	 	   Menu8.setEnabled(false);
	    	 	   Menu9.setEnabled(false);
	    	 	   Menu10.setEnabled(false);
	    	 	   
	    	 	   AlwaysBranchStateOne.setEnabled(false);
	    	 	   AlwaysBranchStateTwo.setEnabled(false);
	    	 	   AlwaysNotBranchStateOne.setEnabled(false);
	    	 	   AlwaysNotBranchStateTwo.setEnabled(false);
	    	 	   Menu11.setEnabled(false);
	    	 	   Menu12.setEnabled(false);
	    	 	   Menu13.setEnabled(false);
	    	 	   
	    	 	   DataForwardingEnable = false;
	    		   WBDECSimultEnable = false;
	    		   BranchPredictType = 0;
	    		   BranchStage = 3;
	    		   JumpStage = 2;
	           }
	       });
	       
	       //Exit Button
	       exitButton.addActionListener(new ActionListener() {
	           @Override
	           public void actionPerformed(ActionEvent e) {
	        	   //save setting to variable
	        	   if(option1.isSelected()){
	        		   DataForwardingEnable = true;
	        	   }
	        	   if(option2or3.isSelected()){
	        		   DataForwardingEnable = false;
	        	   }
	        	   if(option2.isSelected()){
	        		   WBDECSimultEnable = true;
	        	   }
	        	   if(option3.isSelected()){
	        		   WBDECSimultEnable = false;
	        	   }
	        	   if(BranchDEC.isSelected()){
	        		   BranchStage = 2;
	        	   }
	        	   if(BranchEX.isSelected()){
	        		   BranchStage = 3;
	        	   }
	        	   if(BranchMEM.isSelected()){
	        		   BranchStage = 4;
	        	   }
	        	   if(JumpDEC.isSelected()){
	        		   JumpStage = 2;
	        	   }
	        	   if(JumpEX.isSelected()){
	        		   JumpStage = 3;
	        	   }
	        	   if(NoBranchPrediction.isSelected()){
	        		   BranchPredictType = 0;
	        	   }
	        	   if(StaticPrediction.isSelected()){
	        		   BranchPredictType = 1;
	        	   }
	        	   if(DynamicPrediction.isSelected()){
	        		   if(OneBitDynamicPrediction.isSelected()){
	        			   BranchPredictType = 3;
	        		   }
	        		   if(TwoBitDynamicPrediction.isSelected()){
	        			   BranchPredictType = 2;
	        		   }
	        	   }
	        	   if(oneBitAlwaysBranch.isSelected()){
	        		   AlwaysBranchEnable = true;
	        		   State = 1;
	        	   }
	        	   if(oneBitAlwaysNotBranch.isSelected()){
	        		   AlwaysBranchEnable = false;
	        		   State = 0;
	        	   }
	        	   if(AlwaysBranch.isSelected()){
	        		   AlwaysBranchEnable = true;
	        	   }
	        	   if(AlwaysNotBranch.isSelected()){
	        		   AlwaysBranchEnable = false;
	        	   }
	        	   if(AlwaysNotBranchStateOne.isSelected()){
	        		   AlwaysBranchEnable = false;
	        		   State = 0;
	        	   }
	        	   if(AlwaysNotBranchStateTwo.isSelected()){
	        		   AlwaysBranchEnable = false;
	        		   State = 1;
	        	   }
	        	   if(AlwaysBranchStateOne.isSelected()){
	        		   AlwaysBranchEnable = true;
	        		   State = 2;
	        	   }
	        	   if(AlwaysBranchStateTwo.isSelected()){
	        		   AlwaysBranchEnable = true;
	        		   State = 3;
	        	   }
	        	   settingMenu.dispose();
	           }
	       });
	       
	       //add listener to Menu 1 radio button
	       option1.addActionListener(new ActionListener() {
	           @Override
	           public void actionPerformed(ActionEvent e) {
	        	   option2.setEnabled(false);
	        	   option3.setEnabled(false);
	        	   Menu2.setEnabled(false);
	        	   group2.clearSelection();
	           }
	       });
	       
	       option2or3.addActionListener(new ActionListener() {
	           @Override
	           public void actionPerformed(ActionEvent e) {
	        	   option2.setEnabled(true);
	        	   option3.setEnabled(true);
	        	   Menu2.setEnabled(true);
	           }
	       });
	       
	       NoBranchPrediction.addActionListener(new ActionListener(){
	    	   @Override
	    	   public void actionPerformed(ActionEvent e) {
	    		   OneBitDynamicPrediction.setEnabled(false);
	    		   TwoBitDynamicPrediction.setEnabled(false);
	    		   Menu6.setEnabled(false);
	    		   group6.clearSelection();
	    		   
	    		   AlwaysBranch.setEnabled(false);
	        	   AlwaysNotBranch.setEnabled(false);
	        	   Menu7.setEnabled(false);
	        	   group8.clearSelection();
	        	   
	        	   oneBitAlwaysNotBranch.setEnabled(false);
	        	   oneBitAlwaysBranch.setEnabled(false);
	        	   Menu8.setEnabled(false);
	        	   Menu9.setEnabled(false);
	        	   Menu10.setEnabled(false);
	        	   group7.clearSelection();
	        	   
	        	   AlwaysBranchStateOne.setEnabled(false);
	        	   AlwaysBranchStateTwo.setEnabled(false);
	        	   AlwaysNotBranchStateOne.setEnabled(false);
	        	   AlwaysNotBranchStateTwo.setEnabled(false);
	        	   Menu11.setEnabled(false);
	        	   Menu12.setEnabled(false);
	        	   Menu13.setEnabled(false);
	        	   group9.clearSelection();
	           }
	       });
	       
	       StaticPrediction.addActionListener(new ActionListener(){
	    	   @Override
	    	   public void actionPerformed(ActionEvent e) {
	    		   OneBitDynamicPrediction.setEnabled(false);
	    		   TwoBitDynamicPrediction.setEnabled(false);
	    		   Menu6.setEnabled(false);
	    		   group6.clearSelection();
	    		   
	    		   AlwaysBranch.setEnabled(true);
	        	   AlwaysNotBranch.setEnabled(true);
	        	   Menu7.setEnabled(true);
	        	   
	        	   oneBitAlwaysNotBranch.setEnabled(false);
	        	   oneBitAlwaysBranch.setEnabled(false);
	        	   Menu8.setEnabled(false);
	        	   Menu9.setEnabled(false);
	        	   Menu10.setEnabled(false);
	        	   group7.clearSelection();
	        	   
	        	   AlwaysBranchStateOne.setEnabled(false);
	        	   AlwaysBranchStateTwo.setEnabled(false);
	        	   AlwaysNotBranchStateOne.setEnabled(false);
	        	   AlwaysNotBranchStateTwo.setEnabled(false);
	        	   Menu11.setEnabled(false);
	        	   Menu12.setEnabled(false);
	        	   Menu13.setEnabled(false);
	        	   group9.clearSelection();
	           }
	       });
	       
	       DynamicPrediction.addActionListener(new ActionListener(){
	    	   @Override
	    	   public void actionPerformed(ActionEvent e) {
	    		   AlwaysBranch.setEnabled(false);
	        	   AlwaysNotBranch.setEnabled(false);
	        	   Menu7.setEnabled(false);
	        	   group8.clearSelection();
	        	   
	    		   OneBitDynamicPrediction.setEnabled(true);
	    		   TwoBitDynamicPrediction.setEnabled(true);
	    		   Menu6.setEnabled(true);
	           }
	       });
	       
	       OneBitDynamicPrediction.addActionListener(new ActionListener(){
	    	   @Override
	    	   public void actionPerformed(ActionEvent e) {    	
	    		   oneBitAlwaysNotBranch.setEnabled(true);
	        	   oneBitAlwaysBranch.setEnabled(true);
	        	   Menu8.setEnabled(true);
	        	   Menu9.setEnabled(true);
	        	   Menu10.setEnabled(true);
	        	   
	        	   AlwaysBranchStateOne.setEnabled(false);
	        	   AlwaysBranchStateTwo.setEnabled(false);
	        	   AlwaysNotBranchStateOne.setEnabled(false);
	        	   AlwaysNotBranchStateTwo.setEnabled(false);
	        	   Menu11.setEnabled(false);
	        	   Menu12.setEnabled(false);
	        	   Menu13.setEnabled(false);
	        	   group9.clearSelection();
	           }
	       });
	       
	       TwoBitDynamicPrediction.addActionListener(new ActionListener(){
	    	   @Override
	    	   public void actionPerformed(ActionEvent e) {
	    		   oneBitAlwaysNotBranch.setEnabled(false);
	        	   oneBitAlwaysBranch.setEnabled(false);
	        	   Menu8.setEnabled(false);
	        	   Menu9.setEnabled(false);
	        	   Menu10.setEnabled(false);
	        	   group7.clearSelection();
	    		   
	        	   AlwaysBranchStateOne.setEnabled(true);
	        	   AlwaysBranchStateTwo.setEnabled(true);
	        	   AlwaysNotBranchStateOne.setEnabled(true);
	        	   AlwaysNotBranchStateTwo.setEnabled(true);
	        	   Menu11.setEnabled(true);
	        	   Menu12.setEnabled(true);
	        	   Menu13.setEnabled(true);
	           }
	       });
	       JPanel WholeMenu = new JPanel();
	       WholeMenu.add(settingOptions, BorderLayout.WEST);
	       WholeMenu.add(MenuPanel3, BorderLayout.EAST);
	       settingMenu.add(WholeMenu);
	       settingMenu.add(BtmButton,BorderLayout.SOUTH);
	       settingMenu.pack();
	       Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	       int w = settingMenu.getSize().width;
	       int h = settingMenu.getSize().height;
	       int x = (dim.width - w) / 2;
	       int y = (dim.height - h) / 2;
	       settingMenu.setLocation(x, y);
	       settingMenu.setResizable(false);
	   }
	   
	   //display the setting JFrame
	   public void displayOption(){
		   if(DataForwardingEnable){
			   option1.setSelected(true);
			   option2or3.setSelected(false);
			   Menu2.setEnabled(false);
			   option2.setEnabled(false);
			   option3.setEnabled(false);
			   option2.setSelected(false);
			   option3.setSelected(false);
		   }else{
			   option1.setSelected(false);
			   option2or3.setSelected(true);
			   Menu2.setEnabled(true);
			   option2.setEnabled(true);
			   option3.setEnabled(true);
			   if(WBDECSimultEnable){
				   option2.setSelected(true);
				   option3.setSelected(false);
			   }else{
				   option2.setSelected(false);
				   option3.setSelected(true);
			   }
		   }
		   if(BranchStage == 2){
			   BranchDEC.setSelected(true);
			   BranchEX.setSelected(false);
			   BranchMEM.setSelected(false);
		   }else if(BranchStage == 3){
			   BranchDEC.setSelected(false);
			   BranchEX.setSelected(true);
			   BranchMEM.setSelected(false);
		   }else{
			   BranchDEC.setSelected(false);
			   BranchEX.setSelected(false);
			   BranchMEM.setSelected(true);
		   }
		   if(JumpStage == 2){
			   JumpDEC.setSelected(true);
			   JumpEX.setSelected(false);
		   }else{
			   JumpDEC.setSelected(false);
			   JumpEX.setSelected(true);
		   }
		   if(BranchPredictType == 0){
			   NoBranchPrediction.setSelected(true);
			   StaticPrediction.setSelected(false);
			   DynamicPrediction.setSelected(false);
			   
			   OneBitDynamicPrediction.setEnabled(false);
		       TwoBitDynamicPrediction.setEnabled(false);
		 	   Menu6.setEnabled(false);
		 	   group6.clearSelection();
		 	   
			   AlwaysBranch.setEnabled(false);
    	 	   AlwaysNotBranch.setEnabled(false);
    	 	   Menu7.setEnabled(false);
    	 	   group8.clearSelection();
    	 	   
    	 	   oneBitAlwaysBranch.setEnabled(false);
	   	 	   oneBitAlwaysNotBranch.setEnabled(false);
	   	 	   Menu8.setEnabled(false);
	   	 	   Menu9.setEnabled(false);
	   	 	   Menu10.setEnabled(false);
	   	 	   group7.clearSelection();
	   	 	   
    	 	   AlwaysBranchStateOne.setEnabled(false);
    	 	   AlwaysBranchStateTwo.setEnabled(false);
    	 	   AlwaysNotBranchStateOne.setEnabled(false);
    	 	   AlwaysNotBranchStateTwo.setEnabled(false);
    	 	   Menu11.setEnabled(false);
    	 	   Menu12.setEnabled(false);
    	 	   Menu13.setEnabled(false);
    	 	   group9.clearSelection();
		   }else if(BranchPredictType == 1){
			   NoBranchPrediction.setSelected(false);
			   StaticPrediction.setSelected(true);
			   DynamicPrediction.setSelected(false);
			   if(AlwaysBranchEnable){
				   AlwaysBranch.setSelected(true);
				   AlwaysNotBranch.setSelected(false);
			   }else{
				   AlwaysBranch.setSelected(false);
				   AlwaysNotBranch.setSelected(true);
			   }
			   AlwaysBranch.setEnabled(true);
    	 	   AlwaysNotBranch.setEnabled(true);
    	 	   Menu7.setEnabled(true);
    	 	   
    	 	   OneBitDynamicPrediction.setEnabled(false);
		       TwoBitDynamicPrediction.setEnabled(false);
		 	   Menu6.setEnabled(false);
		 	   group6.clearSelection();
		 	   
		 	   oneBitAlwaysBranch.setEnabled(false);
	   	 	   oneBitAlwaysNotBranch.setEnabled(false);
	   	 	   Menu8.setEnabled(false);
	   	 	   Menu9.setEnabled(false);
	   	 	   Menu10.setEnabled(false);
	   	 	   group7.clearSelection();
	   	 	   
    	 	   AlwaysBranchStateOne.setEnabled(false);
    	 	   AlwaysBranchStateTwo.setEnabled(false);
    	 	   AlwaysNotBranchStateOne.setEnabled(false);
    	 	   AlwaysNotBranchStateTwo.setEnabled(false);
    	 	   group9.clearSelection();
    	 	   Menu11.setEnabled(false);
    	 	   Menu12.setEnabled(false);
    	 	   Menu13.setEnabled(false);
		   }else if(BranchPredictType == 2){//2bit dynamic prediction
			   NoBranchPrediction.setSelected(false);
			   StaticPrediction.setSelected(false);
			   DynamicPrediction.setSelected(true);
			   OneBitDynamicPrediction.setEnabled(true);
		       TwoBitDynamicPrediction.setEnabled(true);
		 	   Menu6.setEnabled(true);
		 	   TwoBitDynamicPrediction.setSelected(true);
		 	   OneBitDynamicPrediction.setSelected(false);
			   if(State == 0){
	    	 	   AlwaysBranchStateOne.setSelected(false);
	    	 	   AlwaysBranchStateTwo.setSelected(false);
	    	 	   AlwaysNotBranchStateOne.setSelected(true);
	    	 	   AlwaysNotBranchStateTwo.setSelected(false);
			   }else if(State == 1){
				   AlwaysBranchStateOne.setSelected(false);
	    	 	   AlwaysBranchStateTwo.setSelected(false);
	    	 	   AlwaysNotBranchStateOne.setSelected(false);
	    	 	   AlwaysNotBranchStateTwo.setSelected(true);
			   }else if(State == 2){
				   AlwaysBranchStateOne.setSelected(true);
	    	 	   AlwaysBranchStateTwo.setSelected(false);
	    	 	   AlwaysNotBranchStateOne.setSelected(false);
	    	 	   AlwaysNotBranchStateTwo.setSelected(false);
			   }else{
				   AlwaysBranchStateOne.setSelected(false);
	    	 	   AlwaysBranchStateTwo.setSelected(true);
	    	 	   AlwaysNotBranchStateOne.setSelected(false);
	    	 	   AlwaysNotBranchStateTwo.setSelected(false);
			   }
			   AlwaysBranch.setEnabled(false);
    	 	   AlwaysNotBranch.setEnabled(false);
    	 	   Menu7.setEnabled(false);
    	 	   group8.clearSelection();
    	 	   
    	 	   oneBitAlwaysBranch.setEnabled(false);
	   	 	   oneBitAlwaysNotBranch.setEnabled(false);
	   	 	   Menu8.setEnabled(false);
	   	 	   Menu9.setEnabled(false);
	   	 	   Menu10.setEnabled(false);
	   	 	   group7.clearSelection();
	   	 	   
    	 	   AlwaysBranchStateOne.setEnabled(true);
    	 	   AlwaysBranchStateTwo.setEnabled(true);
    	 	   AlwaysNotBranchStateOne.setEnabled(true);
    	 	   AlwaysNotBranchStateTwo.setEnabled(true);
    	 	   Menu11.setEnabled(true);
    	 	   Menu12.setEnabled(true);
    	 	   Menu13.setEnabled(true);
		   } else {//1bit dynamic prediction
			   NoBranchPrediction.setSelected(false);
			   StaticPrediction.setSelected(false);
			   DynamicPrediction.setSelected(true);
			   OneBitDynamicPrediction.setEnabled(true);
		       TwoBitDynamicPrediction.setEnabled(true);
		 	   Menu6.setEnabled(true);
		 	   TwoBitDynamicPrediction.setSelected(false);
		 	   OneBitDynamicPrediction.setSelected(true);
		 	   if(State == 0){
		 		  oneBitAlwaysBranch.setSelected(false);
		 		  oneBitAlwaysNotBranch.setSelected(true);
		 	   }else{
		 		  oneBitAlwaysBranch.setSelected(true);
		 		  oneBitAlwaysNotBranch.setSelected(false);
		 	   }
		 	   AlwaysBranch.setEnabled(false);
	   	 	   AlwaysNotBranch.setEnabled(false);
	   	 	   Menu7.setEnabled(false);
	   	 	   group8.clearSelection();
	   	 	   
	   	 	   oneBitAlwaysBranch.setEnabled(true);
	   	 	   oneBitAlwaysNotBranch.setEnabled(true);
	   	 	   Menu8.setEnabled(true);
	   	 	   Menu9.setEnabled(true);
	   	 	   Menu10.setEnabled(true);
		   	 	   
	   	 	   AlwaysBranchStateOne.setEnabled(false);
	   	 	   AlwaysBranchStateTwo.setEnabled(false);
	   	 	   AlwaysNotBranchStateOne.setEnabled(false);
	   	 	   AlwaysNotBranchStateTwo.setEnabled(false);
	   	 	   Menu11.setEnabled(false);
	   	 	   Menu12.setEnabled(false);
	   	 	   Menu13.setEnabled(false);
	   	 	   group9.clearSelection();
		   }
		   	// display the settings
		   	settingMenu.setVisible(true);
		   	// display information on the default setting
		   	if(defaultSetting == null){
			    JEditorPane editorPane = null;
				String html = "<!DOCTYPE html><html><head><title>Page Title</title></head><body style=\"margin: 0px 10px 5px 10px;\"><h1><u>Pipelined Processor Simulator Default Setting</u></h1>"
						+ "<h3>Default Setting:</h3><ul><li>Data Forwarding is Not Enabled</li><li>Decode and WriteBack cannot occur simultaneously</li>"
						+ "<li>Branch Instruction Evaluated at Execute Stage</li><li>Jump Instruction Evaluated at Decode Stage</li>"
						+ "<li>No Branch Prediction technique is being used</li></ul><p>The Settings can be changed according to the user requirement</p></body></html>";
				editorPane = new JEditorPane("text/html", html);
				editorPane.setEditable(false);
				dontShowAgain = new JCheckBox("Don't Show Again");
				defaultSetting = new JFrame("Default Setting Information");
				defaultSetting.getContentPane().add(editorPane, BorderLayout.CENTER);
				defaultSetting.getContentPane().add(dontShowAgain, BorderLayout.SOUTH);
				defaultSetting.pack();
				Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
				int w = defaultSetting.getSize().width;
				int h = defaultSetting.getSize().height;
				int x = (dim.width - w) / 2;
				int y = (dim.height - h) / 2;
				defaultSetting.setLocation(x, y);
				defaultSetting.setResizable(false);
		   	}
			if(!dontShowAgain.isSelected())
				defaultSetting.setVisible(true);
	   }

}
