package mars.tools;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class InitialRegisterMemoryValue {
	
	JFrame regWindow = new JFrame("Register Value Initialisation Window");
	JLabel registers[];
	JTextField registersValue[];
	public InitialRegisterMemoryValue(){
		registers = new JLabel[27];
		registersValue = new JTextField[27];
		GridLayout registerLayout = new GridLayout(0,2);
		JPanel registerWindow = new JPanel();
		JButton reset = new JButton("Reset Default Value");
		reset.setSize(100, 40);
		registerWindow.setLayout(registerLayout);
		for(int i= 0; i < 27; i++){
			int j = i + 1;
			String labelName = "$" + j + " : ";
			registers[i] = new JLabel(labelName, JLabel.RIGHT);
			registersValue[i] = new JTextField("0", 8);
			registerWindow.add(registers[i]);
			registerWindow.add(registersValue[i]);
		}
		regWindow.add(registerWindow, BorderLayout.CENTER);
		regWindow.add(reset, BorderLayout.SOUTH);
		reset.addActionListener(new ActionListener(){
			 public void actionPerformed(ActionEvent e) {
				 for(int i= 0; i < 27; i++){
						registersValue[i].setText("0");
				}
			 }
		});
	}
	
	public void displayWindow(){
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		regWindow.pack();
		int w = regWindow.getSize().width;
		int h = regWindow.getSize().height;
		int x = (dim.width - w) / 2;
		int y = (dim.height - h) / 2;
		regWindow.setLocation(x, y);
		regWindow.setResizable(false);
		regWindow.setVisible(true);
	}
}
