package mars.tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

import mars.Globals;
import mars.ProgramStatement;
import mars.mips.hardware.AddressErrorException;
import mars.mips.hardware.Memory;
import mars.mips.hardware.RegisterFile;
import mars.mips.instructions.BasicInstruction;
import mars.mips.instructions.BasicInstructionFormat;
import mars.venus.ExecutePane;
import mars.venus.GuiAction;
import mars.venus.RunAssembleAction;
import mars.venus.RunStepAction;
import mars.venus.VenusUI;

public class DependencyCheck{
	//variable Declaration
	//declaration for the action button
    private static JPanel resultpane;
    private static JTextArea testing;
    private static SettingOption settingObj = null;
	//Declaration
	private static int lastAddress = 0;
  
	public DependencyCheck(){
		
	}
	
   //For Display the new instruction without WAR dependency
   private static JPanel setUpTestingGUI(){
	   JPanel resultPane = new JPanel();
	   testing = new JTextArea(25,35);
	   JScrollPane scrollPane = new JScrollPane(testing);
	   resultPane.add(scrollPane);
	   return resultPane;
   }

   public static void checkDependency(){
	   settingObj = PipelinedMipsSimulator.getSettingObject();
	   String newInstruction = "";
	   ProgramStatement fetchInst = null, secondInst = null, thirdInst = null, fourthInst = null;
	   BasicInstruction Firstinstr = null;	   
	   int curPc;
	   int raw = 0;
	   lastAddress = ((ProgramStatement)(Globals.program.getMachineList().get(Globals.program.getMachineList().size()-1) )).getAddress();
	   while(RegisterFile.getProgramCounter() <= lastAddress){
		   try{
			   fetchInst = Globals.memory.getStatement(RegisterFile.getProgramCounter());
			   curPc = RegisterFile.getProgramCounter();
			   if(settingObj.DataForwardingEnable){
				   Firstinstr = (BasicInstruction) Globals.memory.getStatement(curPc).getInstruction();
				   if(curPc == lastAddress){
					   if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT) {//if last instruction is jump
						   switch(settingObj.JumpStage){
					   			case 2:	raw = 1;
					   					break;
					   			case 3:	raw = 2;
					   					break;
						   }
					   }else if (Firstinstr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT) {//if last instruction is branch
						   switch(settingObj.BranchStage){
						   		case 2:	raw = 1;
						   				break;
						   		case 3:	raw = 2;
						   				break;
						   		case 4:	raw = 3;
				   						break;
						   }
					   } else if(fetchInst.getInstruction().getName().equals("jr")){//need 1 nop becuz jr execute a jump in ID stage
						   raw = 1;
					   }else {
						   raw = 0;
					   }
				   }else if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
					   if(settingObj.BranchPredictType == 0){//if no branch prediction is used
						   int NoOfInstrCheckedForNop = 0;
						   switch(settingObj.BranchStage){
						   		case 2:	raw = 1;
						   				while(NoOfInstrCheckedForNop < 1){
						   					NoOfInstrCheckedForNop++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrCheckedForNop));
						   					if(instToCheck != null) {
							   					if(instToCheck.getInstruction().getName().equals("nop")){
							   						raw--;
							   					}else{
							   						break;
							   					}
						   					}else {
						   						break;
						   					}
						   				}
						   				break;
						   		case 3:	raw = 2;
								   		while(NoOfInstrCheckedForNop < 2){
						   					NoOfInstrCheckedForNop++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrCheckedForNop));
						   					if(instToCheck != null) {
							   					if(instToCheck.getInstruction().getName().equals("nop")){
							   						raw--;
							   					}else{
							   						break;
							   					}
						   					}else {
						   						break;
						   					}
						   				}
						   				break;
						   		case 4:	raw = 3;
								   		while(NoOfInstrCheckedForNop < 3){
						   					NoOfInstrCheckedForNop++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrCheckedForNop));
						   					if(instToCheck != null) {
							   					if(instToCheck.getInstruction().getName().equals("nop")){
							   						raw--;
							   					}else{
							   						break;
							   					}
						   					}else {
						   						break;
						   					}
						   				}
			   							break;			
						   }
					   }else{//if branch prediction is used
						   int NoOfInstrChecked = 0;
						   switch(settingObj.BranchStage){
						   		case 2:	raw = 1;
						   				while(NoOfInstrChecked < 1){
						   					NoOfInstrChecked++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
						   					if(instToCheck != null) {
							   						raw--;
						   					}else {
						   						break;
						   					}
						   				}
						   				break;
						   		case 3:	raw = 2;
								   		while(NoOfInstrChecked < 2){
								   			NoOfInstrChecked++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
						   					if(instToCheck != null) {
						   						raw--;
						   					}else {
						   						break;
						   					}
						   				}
						   				break;
						   		case 4:	raw = 3;
								   		while(NoOfInstrChecked < 3){
								   			NoOfInstrChecked++;
						   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
						   					if(instToCheck != null) {
						   						raw--;
						   					}else {
						   						break;
						   					}
						   				}
			   							break;			
						   }
					   }
				   }else if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
					   switch(settingObj.JumpStage){
					   		case 2:	raw = checkTwoInstruction(curPc, fetchInst, Globals.memory.getStatement(curPc+4));
					   				break;
					   		case 3:	if(Globals.memory.getStatement(curPc+8) != null){
					   					raw = checkThreeInstruction(curPc, fetchInst, Globals.memory.getStatement(curPc+4), Globals.memory.getStatement(curPc+8));
					   				}else {
					   					raw = checkTwoInstruction(curPc, fetchInst, Globals.memory.getStatement(curPc+4));
					   				}
					   				break;
					   }
				   }else if(fetchInst.getInstruction().getName().equals("jr")){
					   raw = 1;
				   }else if(settingObj.BranchStage == 2){//if first instruction is R or I type and branch at DEC stage
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   raw = checkTwoInstruction(curPc, fetchInst, secondInst);
					   BasicInstruction Secondinstr = (BasicInstruction) Globals.memory.getStatement(curPc + 4).getInstruction();
					   if(raw != 0){//if there is dependency with adjacent instruction
						   if(Secondinstr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){//if the secondInstr is branch
							   raw = 1;
						   }else{
							   raw = 0;
						   }
					   }
				   }else if(fetchInst.getInstruction().getName().equals("lw")){
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   raw = checkTwoInstruction(curPc, fetchInst, secondInst);
				   }
			   }else if(settingObj.WBDECSimultEnable){
				   //check for RAW dependency (DEC and WB Simultaneously Enable)
				   Firstinstr = (BasicInstruction) Globals.memory.getStatement(curPc).getInstruction();
				   //==================================check if only one instruction left==================================//
				   if(curPc == lastAddress){
					   if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT) {
						   switch(settingObj.JumpStage){
				   			case 2:	raw = 1;
				   					break;
				   			case 3:	raw = 2;
				   					break;
						   }
					   }else if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT) {
						   switch(settingObj.BranchStage){
					   		case 2:	raw = 1;
					   				break;
					   		case 3:	raw = 2;
					   				break;
					   		case 4:	raw = 3;
			   						break;
						   }
					   }else if(fetchInst.getInstruction().getName().equals("jr")){//need 1 nop becuz jr execute a jump in ID stage
						   raw = 1;
					   }else {
						   raw = 0;
					   }
				   } else if((curPc+4) == lastAddress){ //=============================check if only two instruction left=========================================//
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   raw = checkTwoInstruction(curPc, fetchInst, secondInst);
				   } else { //================================check three consecutive instruction=======================================//
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   thirdInst = Globals.memory.getStatement(curPc + 8);
					   raw = checkThreeInstruction(curPc, fetchInst, secondInst, thirdInst);
				   }//end check for three consecutive instruction
			   }else{
				   //check for RAW dependency (DEC and WB Simultaneously Disable)
				   //==================================check if only one instruction left==================================//
				   if(curPc == lastAddress){
					   if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT) {
						   switch(settingObj.JumpStage){
				   			case 2:	raw = 1;
				   					break;
				   			case 3:	raw = 2;
				   					break;
						   }
					   }else if(Firstinstr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT) {
						   switch(settingObj.BranchStage){
					   		case 2:	raw = 1;
					   				break;
					   		case 3:	raw = 2;
					   				break;
					   		case 4:	raw = 3;
			   						break;
						   }
					   }else if(fetchInst.getInstruction().getName().equals("jr")){//need 1 nop becuz jr execute a jump in ID stage
						   raw = 1;
					   }else {
						   raw = 0;
					   }
				   } else if((curPc+4) == lastAddress){ //=============================check if only two instruction left=========================================//
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   raw = checkTwoInstruction(curPc, fetchInst, secondInst);
				   } else if((curPc+8) == lastAddress){ //================================check if only three instruction left=======================================//
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   thirdInst = Globals.memory.getStatement(curPc + 8);
					   raw = checkThreeInstruction(curPc, fetchInst, secondInst, thirdInst);
				   } else {//================================check four consecutive instruction=======================================//
					   secondInst = Globals.memory.getStatement(curPc + 4);
					   thirdInst = Globals.memory.getStatement(curPc + 8);
					   fourthInst = Globals.memory.getStatement(curPc + 12);
					   raw = checkFourInstruction(curPc, fetchInst, secondInst, thirdInst, fourthInst);
				   }//end check for four consecutive instruction
			   }
			   
		   }
		   catch(AddressErrorException e){
			   
		   }
		   if(raw == 0){
			   newInstruction += fetchInst.getSource() + "\n";
		   }else if(raw == 1){
			   newInstruction += fetchInst.getSource() + "\n" + "nop #nop added by checker" + "\n";
		   }else if (raw == 2){
			   newInstruction += fetchInst.getSource() + "\n" + "nop #nop added by checker" + "\n" + "nop #nop added by checker" + "\n";
		   }else if (raw == 3){
			   newInstruction += fetchInst.getSource() + "\n" + "nop #nop added by checker" + "\n" + "nop #nop added by checker" + "\n" + "nop #nop added by checker" + "\n";
		   }
		   //reset raw
		   raw = 0;
		   //move to next instruction
		   RegisterFile.setProgramCounter(RegisterFile.getProgramCounter() + 4);
	   }
	   resultpane = setUpTestingGUI();
	   testing.setText(newInstruction);
	   JFrame correctInstruction = new JFrame("New corrected MIPS program Codes");
	   correctInstruction.add(resultpane);
       Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
       int w = correctInstruction.getSize().width;
       int h = correctInstruction.getSize().height;
       int x = (dim.width - w) / 2;
       int y = (dim.height - h) / 2;
       correctInstruction.setLocation(x, y);
       correctInstruction.setResizable(false);
       correctInstruction.pack();
       correctInstruction.setVisible(true);
	   
   }
   
   private static int checkTwoInstruction(int curPc, ProgramStatement fetchInst, ProgramStatement fetchSecInst) {
	   int destination = -1;
	   BasicInstruction instr = null, secondInst = null;
	   ArrayList<Integer> source = null;
	   try{
		   	secondInst= (BasicInstruction) Globals.memory.getStatement(curPc + 4).getInstruction();
		    instr = (BasicInstruction) Globals.memory.getStatement(curPc).getInstruction();
	   }catch(AddressErrorException e){
		   
	   }
	   //========first instruction (find the destination/write)========//
	   if( instr.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   if(!(fetchInst.getInstruction().getName().equals("sw") || fetchInst.getInstruction().getName().equals("sb")))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(11, 16), 2);
	   } else if(instr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   if(settingObj.BranchPredictType == 0){//if no branch predictor used
			   int raw = 0;
			   switch(settingObj.BranchStage){
			   		case 2:	raw = 1;
			   				if(fetchSecInst.getInstruction().getName().equals("nop"))
			   					raw--;
			   				return raw;
			   		case 3:	raw = 2;
					   		if(fetchSecInst.getInstruction().getName().equals("nop"))
								raw--;
			   				return raw;
			   		case 4:	raw = 3;
					   		if(fetchSecInst.getInstruction().getName().equals("nop"))
								raw--;
			   				return raw;
			   }
		   }else{//if branch predictor used
			   int NoOfInstrChecked = 0;
			   int raw = 0;
			   try {
				   switch(settingObj.BranchStage){
				   		case 2:	raw = 1;
				   				while(NoOfInstrChecked < 1){
				   					NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
					   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 3:	raw = 2;
						   		while(NoOfInstrChecked < 2){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 4:	raw = 3;
						   		while(NoOfInstrChecked < 3){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
	   							break;			
				   }
				   return raw;
			   }catch(AddressErrorException e) {
				   
			   }
		   }
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(fetchInst.getInstruction().getName().equals("jr"))
			   return 1;
		   if(!fetchInst.getInstruction().getName().equals("nop"))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(16, 21), 2);
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   int raw = 0;
		   switch(settingObj.JumpStage){
			   case 2:	raw = 1;
						if(fetchSecInst.getInstruction().getName().equals("nop"))
							raw--;
						return raw;
			   case 3:	raw = 2;
			   			if(fetchSecInst.getInstruction().getName().equals("nop"))
			   				raw--;
			   			return raw;	
		   }
	   }
	   
	   //========second instruction (find the read/source)========//
	   source = new ArrayList<Integer>(); 
	   if( secondInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("sw") || fetchSecInst.getInstruction().getName().equals("sb"))
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
	   } else if(secondInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(!fetchSecInst.getInstruction().getName().equals("nop")){
			   if(fetchSecInst.getInstruction().getName().equals("jr")){
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
			   }else{
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
			   }
		   }
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("bne") || fetchSecInst.getInstruction().getName().equals("beq")){
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
		   }
	   }
	   
	   //========check destination against source (RAW)========//
		Iterator<Integer> sourceIterator = source.iterator();
		String value1 ="";
		while (sourceIterator.hasNext()) {
			int value = sourceIterator.next();
			if(destination == value){
				if(settingObj.DataForwardingEnable){
					return 1;
				}else if (settingObj.WBDECSimultEnable){
					return 2;
				}else{
					return 3;
				}
			}
		}
		return 0;
   }
   
   private static int checkThreeInstruction(int curPc, ProgramStatement fetchInst, ProgramStatement fetchSecInst, ProgramStatement fetchThirdInst){
	   BasicInstruction instr = null, secondInst = null, thirdInst = null;
	   int destination = -1;
	   ArrayList<Integer> source = null;
	   int SecondThirdDep = 0;
	   try{
		   thirdInst = (BasicInstruction) Globals.memory.getStatement(curPc + 8).getInstruction();
		   secondInst = (BasicInstruction) Globals.memory.getStatement(curPc + 4).getInstruction();
	   }catch(AddressErrorException e){
		   
	   }
	   instr = (BasicInstruction) fetchInst.getInstruction();
	   
	   //first instruction (find the destination/write)
	   if( instr.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   if(!(fetchInst.getInstruction().getName().equals("sw") || fetchInst.getInstruction().getName().equals("sb")))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(11, 16), 2);
	   } else if(instr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   if(settingObj.BranchPredictType == 0){
			   int raw = 0;
			   switch(settingObj.BranchStage){
			   		case 2:	raw = 1;
			   				if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   				}
			   				return raw;
			   		case 3:	raw = 2;
					   		if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   					if(fetchThirdInst.getInstruction().getName().equals("nop"))
			   						raw--;
			   				}
			   				return raw;
			   		case 4:	raw = 3;
					   		if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   					if(fetchThirdInst.getInstruction().getName().equals("nop"))
			   						raw--;			   					
			   				}
			   				return raw;
			   }
		   }else{//if branch predictor used
			   int NoOfInstrChecked = 0;
			   int raw = 0;
			   try {
				   switch(settingObj.BranchStage){
				   		case 2:	raw = 1;
				   				while(NoOfInstrChecked < 1){
				   					NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
					   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 3:	raw = 2;
						   		while(NoOfInstrChecked < 2){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 4:	raw = 3;
						   		while(NoOfInstrChecked < 3){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
	   							break;			
				   }
				   return raw;
			   }catch(AddressErrorException e) {
				   
			   }
		   }
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(fetchInst.getInstruction().getName().equals("jr"))
			   return 1;
		   if(!fetchInst.getInstruction().getName().equals("nop"))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(16, 21), 2);
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   int raw = 0;
		   switch(settingObj.JumpStage){
			   case 2:	raw = 1;
						if(fetchSecInst.getInstruction().getName().equals("nop")){
							raw--;
						}
						return raw;
			   case 3:	raw = 2;
			   			if(fetchSecInst.getInstruction().getName().equals("nop")){
							raw--;
							if(fetchThirdInst.getInstruction().getName().equals("nop"))
								raw--;
						}
						return raw;
	
		   }
	   }
	   
	   //second instruction (find the read/source)
	   source = new ArrayList<Integer>(); 
	   if( secondInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("sw") || fetchSecInst.getInstruction().getName().equals("sb"))
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
	   } else if(secondInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(!fetchSecInst.getInstruction().getName().equals("nop")){
			   if(fetchSecInst.getInstruction().getName().equals("jr")){
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2)); 
			   }else{
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
			   }
		   }
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("bne") || fetchSecInst.getInstruction().getName().equals("beq")){
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
		   }
	   }
	   
	   //check destination against source of second instruction (RAW)
		Iterator<Integer> sourceIterator = source.iterator();
		while (sourceIterator.hasNext()) {
			if(destination == sourceIterator.next()){
				if(settingObj.DataForwardingEnable){
					return 0;
				}else if (settingObj.WBDECSimultEnable){
					return 2;
				}else{
					return 3;
				}
			}
		}
		
		//third instruction (find the read/source)
		source = new ArrayList<Integer>(); 
		if(thirdInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchThirdInst.getInstruction().getName().equals("sw") || fetchThirdInst.getInstruction().getName().equals("sb"))
			   source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
		} else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
			   
		}else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
			if(!fetchThirdInst.getInstruction().getName().equals("nop")){
				if(fetchThirdInst.getInstruction().getName().equals("jr")){
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
				}else{
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
				}
			}
		}else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchThirdInst.getInstruction().getName().equals("bne") || fetchThirdInst.getInstruction().getName().equals("beq")){
			   source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
		   }
		}
		   
	   	//check destination against source third instruction(RAW)
		sourceIterator = source.iterator();
		while (sourceIterator.hasNext()) {
			if(destination == sourceIterator.next()){
				//check if second and third instruction have RAW dependency
				SecondThirdDep = checkTwoInstruction(curPc+4, fetchSecInst, fetchThirdInst);
				//if not dependency between second and third
				if(SecondThirdDep == 0){
					if (settingObj.WBDECSimultEnable){
						return 1;
					}else{
						return 2;
					}
				}else {
					return 0;
				}
			}
		}
		return 0;
   }
   
   private static int checkFourInstruction(int curPc, ProgramStatement fetchInst, ProgramStatement fetchSecInst, ProgramStatement fetchThirdInst, ProgramStatement fetchFourthInst){
	   BasicInstruction instr = null, secondInst = null, thirdInst = null, fourthInst = null;
	   int destination = -1;
	   ArrayList<Integer> source = null;
	   int SecondThirdDep = 0;
	   int SecondThirdFourthDep = 0;
	   try{
		   fourthInst = (BasicInstruction) Globals.memory.getStatement(curPc + 12).getInstruction();
		   thirdInst = (BasicInstruction) Globals.memory.getStatement(curPc + 8).getInstruction();
		   secondInst = (BasicInstruction) Globals.memory.getStatement(curPc + 4).getInstruction();
	   }catch(AddressErrorException e){
		   
	   }
	   instr = (BasicInstruction) fetchInst.getInstruction();
	   
	   //first instruction (find the destination/write)
	   if( instr.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   if(!(fetchInst.getInstruction().getName().equals("sw") || fetchInst.getInstruction().getName().equals("sb")))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(11, 16), 2);
	   } else if(instr.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   if(settingObj.BranchPredictType == 0){
			   int raw = 0;
			   switch(settingObj.BranchStage){
			   		case 2:	raw = 1;
					   		if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   				}
			   				return raw;
			   		case 3:	raw = 2;
					   		if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   					if(fetchThirdInst.getInstruction().getName().equals("nop"))
			   						raw--;
			   				}
			   				return raw;
			   		case 4:	raw = 3;
					   		if(fetchSecInst.getInstruction().getName().equals("nop")){
			   					raw--;
			   					if(fetchThirdInst.getInstruction().getName().equals("nop")){
			   						raw--;
			   						if(fetchFourthInst.getInstruction().getName().equals("nop"))
			   							raw--;
			   					}
			   				}else{
			   					return raw;
			   				}
			   				return raw;
			   }
		   }else{//if branch predictor used
			   int NoOfInstrChecked = 0;
			   int raw = 0;
			   try {
				   switch(settingObj.BranchStage){
				   		case 2:	raw = 1;
				   				while(NoOfInstrChecked < 1){
				   					NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
					   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 3:	raw = 2;
						   		while(NoOfInstrChecked < 2){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
				   				break;
				   		case 4:	raw = 3;
						   		while(NoOfInstrChecked < 3){
						   			NoOfInstrChecked++;
				   					ProgramStatement instToCheck = Globals.memory.getStatement(curPc + (4*NoOfInstrChecked));
				   					if(instToCheck != null) {
				   						raw--;
				   					}else {
				   						break;
				   					}
				   				}
	   							break;			
				   }
				   return raw;
			   }catch(AddressErrorException e) {
				   
			   }
		   }
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(fetchInst.getInstruction().getName().equals("jr"))
			   return 1;
		   if(!fetchInst.getInstruction().getName().equals("nop"))
			   destination = Integer.parseInt(fetchInst.getMachineStatement().substring(16, 21), 2);
	   }else if(instr.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   int raw = 0;
		   switch(settingObj.JumpStage){
		   		case 2:	raw = 1;
				   		if(fetchSecInst.getInstruction().getName().equals("nop")){
		   					raw--;
		   				}
				   		return raw;
		   		case 3:	raw = 2;
				   		if(fetchSecInst.getInstruction().getName().equals("nop")){
		   					raw--;
		   					if(fetchThirdInst.getInstruction().getName().equals("nop"))
		   						raw--;
		   				}
		   				return raw;	
		   }
	   }
	   
	   //second instruction (find the read/source)
	   source = new ArrayList<Integer>(); 
	   if( secondInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("sw") || fetchSecInst.getInstruction().getName().equals("sb"))
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
	   } else if(secondInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
		   
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
		   if(!fetchSecInst.getInstruction().getName().equals("nop")){
			   if(fetchSecInst.getInstruction().getName().equals("jr")){
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
			   }else{
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
				   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
			   }
		   }
	   }else if(secondInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
		   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(6, 11), 2));
		   if(fetchSecInst.getInstruction().getName().equals("bne") || fetchSecInst.getInstruction().getName().equals("beq")){
			   source.add(Integer.parseInt(fetchSecInst.getMachineStatement().substring(11, 16), 2));
		   }
	   }
	   
	   //check destination against source of second instruction (RAW)
		Iterator<Integer> sourceIterator = source.iterator();
		while (sourceIterator.hasNext()) {
			if(destination == sourceIterator.next()){
				return 3;
			}
		}
		
		//third instruction (find the read/source)
		source = new ArrayList<Integer>(); 
		if(thirdInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
			source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
			if(fetchThirdInst.getInstruction().getName().equals("sw") || fetchThirdInst.getInstruction().getName().equals("sb"))
				source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
		} else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
			   
		}else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
			if(!fetchThirdInst.getInstruction().getName().equals("nop")){
				if(fetchThirdInst.getInstruction().getName().equals("jr")){
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
				}else{
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
					source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
				}
			}
		}else if(thirdInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
			source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(6, 11), 2));
			if(fetchThirdInst.getInstruction().getName().equals("bne") || fetchThirdInst.getInstruction().getName().equals("beq")){
				source.add(Integer.parseInt(fetchThirdInst.getMachineStatement().substring(11, 16), 2));
			}
		}
		   
	   	//check destination against source third instruction(RAW)
		sourceIterator = source.iterator();
		while (sourceIterator.hasNext()) {
			if(destination == sourceIterator.next()){
				//check if second and third instruction have RAW dependency
				SecondThirdDep = checkTwoInstruction(curPc+4, fetchSecInst, fetchThirdInst);
				//if not dependency between second and third
				if(SecondThirdDep == 0){
					return 2;
				}else {
					return 0;
				}
			}
		}
		
		//fourth instruction (find the read/source)
		source = new ArrayList<Integer>(); 
		if(fourthInst.getInstructionFormat() == BasicInstructionFormat.I_FORMAT){
			source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(6, 11), 2));
			if(fetchFourthInst.getInstruction().getName().equals("sw") || fetchFourthInst.getInstruction().getName().equals("sb"))
				source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(11, 16), 2));
		} else if(fourthInst.getInstructionFormat() == BasicInstructionFormat.J_FORMAT){
			   
		}else if(fourthInst.getInstructionFormat() == BasicInstructionFormat.R_FORMAT){
			if(!fetchFourthInst.getInstruction().getName().equals("nop")){
				if(fetchFourthInst.getInstruction().getName().equals("jr")){
					source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(6, 11), 2));
				}else{
					source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(6, 11), 2));
					source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(11, 16), 2));
				}
			}
		}else if(fourthInst.getInstructionFormat() == BasicInstructionFormat.I_BRANCH_FORMAT){
			source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(6, 11), 2));
			if(fetchFourthInst.getInstruction().getName().equals("bne") || fetchFourthInst.getInstruction().getName().equals("beq")){
				source.add(Integer.parseInt(fetchFourthInst.getMachineStatement().substring(11, 16), 2));
			}
		}
		   
	   	//check destination against source third instruction(RAW)
		sourceIterator = source.iterator();
		while (sourceIterator.hasNext()) {
			if(destination == sourceIterator.next()){
				//check if second , third and fourth instruction have RAW dependency
				SecondThirdFourthDep = checkThreeInstruction(curPc+4, fetchSecInst, fetchThirdInst, fetchFourthInst);
				//if not dependency between second, third and fourth
				if(SecondThirdFourthDep == 0){
					return 1;
				}else {
					return 0;
				}
			}
		}
		
		return 0;
   }
   
}
